<?php
require 'conexion.php'; // Incluye el archivo de conexión

// Verificar si los campos necesarios están definidos en $_POST
if (!isset($_POST['Corigen'])) {
    die("Error: No se proporcionó el ID del pedido.");
}

// Variables del formulario
$Corigen = $_POST['Corigen']; // ID del pedido
$vendedorNombre = 'Nombre del Vendedor'; // Este valor debería venir de otro formulario o sesión
$vendedorId = 1; // Este valor debería venir de otro formulario o sesión

// Consulta para obtener los detalles del pedido
$sql = "SELECT DISTINCT 
            s.nom AS Cliente, 
            c.ref AS Ref_Pedido, 
            c.date_creation AS Fecha_Creacion, 
            p.rowid AS id_producto, 
            p.label AS Producto, 
            cd.description AS descripcion, 
            cd.qty AS Cantidad, 
            u.nom_unidad AS Tipo_despacho, 
            extra2.cantidad_despacho AS Cantidad_Despacho
        FROM 
            llx_societe AS s 
        INNER JOIN 
            llx_commande AS c ON c.fk_soc = s.rowid
        INNER JOIN 
            llx_commandedet AS cd ON c.rowid = cd.fk_commande
        LEFT JOIN 
            llx_projet AS pj ON c.fk_projet = pj.rowid
        LEFT JOIN 
            llx_user AS uc ON c.fk_user_author = uc.rowid
        LEFT JOIN 
            llx_user AS uv ON c.fk_user_valid = uv.rowid
        LEFT JOIN 
            llx_commande_extrafields AS extra ON c.rowid = extra.fk_object
        LEFT JOIN 
            llx_commandedet_extrafields AS extra2 ON cd.rowid = extra2.fk_object
        LEFT JOIN 
            llx_udd AS u ON extra2.cestas = u.cod_unidad
        LEFT JOIN 
            llx_product AS p ON cd.fk_product = p.rowid
        LEFT JOIN 
            llx_product_extrafields AS extra3 ON p.rowid = extra3.fk_object
        WHERE 
            c.rowid = '$Corigen'"; // Usamos el ID del pedido obtenido

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Iterar sobre cada línea del pedido
    while ($row = $result->fetch_assoc()) {
        $Pcantidad = $row['Cantidad']; // Cantidad del producto actual
        $Prowid = $row['id_producto']; // ID del producto actual

        // Insertar en llx_despacho_nuevo
        $sqlInsert = "INSERT INTO llx_despacho_nuevo (cliente, ref_pedido, fecha_creacion, producto, descripcion, cantidad, tipo_despacho, Cantidad_Despacho, usuario_sistema)
                      VALUES ('" . $row['Cliente'] . "', '$Corigen', NOW(), '" . $row['Producto'] . "', '" . $row['descripcion'] . "', $Pcantidad, '" . $row['Tipo_despacho'] . "', $Pcantidad, '$vendedorNombre')";
        if ($conn->query($sqlInsert) === TRUE) {
            echo "Registro insertado correctamente en llx_despacho_nuevo para el producto: " . $row['Producto'] . "<br>";
        } else {
            echo "Error al insertar en llx_despacho_nuevo: " . $conn->error . "<br>";
        }

        // Update llx_product_stock
        $sqlUpdateStock = "UPDATE llx_product_stock SET reel = reel - $Pcantidad WHERE fk_product = $Prowid AND fk_entrepot = 4";
        if ($conn->query($sqlUpdateStock) === TRUE) {
            echo "Stock actualizado correctamente en llx_product_stock para el producto: " . $row['Producto'] . "<br>";
        } else {
            echo "Error al actualizar llx_product_stock: " . $conn->error . "<br>";
        }

        // Update llx_product
        $sqlUpdateProduct = "UPDATE llx_product SET stock = stock - $Pcantidad WHERE rowid = $Prowid";
        if ($conn->query($sqlUpdateProduct) === TRUE) {
            echo "Stock actualizado correctamente en llx_product para el producto: " . $row['Producto'] . "<br>";
        } else {
            echo "Error al actualizar llx_product: " . $conn->error . "<br>";
        }

        // Insertar en llx_stock_mouvement
        $sqlInsertMov = "INSERT INTO llx_stock_mouvement (fk_product, tms, datem, value, fk_entrepot, fk_user_author, label, type_mouvement, fk_origin, origintype)
                         VALUES ($Prowid, NOW(), NOW(), -$Pcantidad, 4, $vendedorId, 'Expedición por salida de producto del almacén', 2, '$Corigen', 'commande')";
        if ($conn->query($sqlInsertMov) === TRUE) {
            echo "Movimiento insertado correctamente en llx_stock_mouvement para el producto: " . $row['Producto'] . "<br>";
        } else {
            echo "Error al insertar en llx_stock_mouvement: " . $conn->error . "<br>";
        }
    }

    // Actualizar el estado del pedido en llx_commande
    $sqlUpdateCommande = "UPDATE llx_commande SET fk_statut = '3' WHERE rowid = '$Corigen'";
    if ($conn->query($sqlUpdateCommande) === TRUE) {
        echo "Estado del pedido actualizado correctamente en llx_commande.<br>";
    } else {
        echo "Error al actualizar el estado del pedido en llx_commande: " . $conn->error . "<br>";
    }

    echo "Despacho realizado con éxito para todas las líneas del pedido.";
} else {
    echo "No se encontraron líneas para el pedido: $Corigen";
}

// Cerrar la conexión
$conn->close();
?>